/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Label;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ptidej.ui.Canvas;
import ptidej.ui.Drawable;
import ptidej.ui.kernel.Constituent;
import ptidej.ui.kernel.GraphicModel;
import ptidej.ui.solution.GroupSolution;
import ptidej.viewer.core.AWTCanvas;

public class ConstraintSolutionsActionListener
implements ActionListener {
    public static final String GO_TO = "Go to";
    public static final String SHOW_HIDE = "Show/Hide";
    public static final String FOLD_UNFOLD = "Fold/Unfold";
    public static final String FOLD_UNFOLD_ALL = "Fold/Unfold All";
    public static final String FOLD_UNFOLD_OBJECT = "Fold/Unfold containing Object";
    private final Canvas canvas;
    private final AWTCanvas awtCanvas;
    private final GraphicModel graphicModel;

    public ConstraintSolutionsActionListener(Canvas canvas, AWTCanvas awtCanvas, GraphicModel graphicModel) {
        this.canvas = canvas;
        this.awtCanvas = awtCanvas;
        this.graphicModel = graphicModel;
    }

    public void actionPerformed(ActionEvent e) {
        String sourceName = ((PopupMenu)((MenuItem)e.getSource()).getParent()).getName();
        if (e.getActionCommand().equals(GO_TO)) {
            Constituent[] constituents = this.graphicModel.getConstituents();
            int i = 0;
            while (i < constituents.length) {
                if (constituents[i].getName().equals(sourceName)) {
                    this.awtCanvas.goTo(constituents[i].getPosition());
                }
                ++i;
            }
        } else if (e.getActionCommand().equals(FOLD_UNFOLD)) {
            Panel panel = (Panel)((Component)((MenuComponent)((PopupMenu)((MenuItem)e.getSource()).getParent())).getParent()).getParent().getParent();
            Component[] components = panel.getComponents();
            int j = 0;
            while (j < components.length) {
                if (components[j].getName().equals(sourceName)) {
                    Component[] subComponents = ((Panel)components[j]).getComponents();
                    int k = 1;
                    while (k < subComponents.length) {
                        subComponents[k].setVisible(!subComponents[k].isVisible());
                        ++k;
                    }
                }
                ++j;
            }
            Container frame = panel;
            while (!(frame instanceof Frame)) {
                frame = frame.getParent();
            }
            ((Frame)frame).pack();
        } else if (e.getActionCommand().equals(FOLD_UNFOLD_ALL)) {
            Panel panel = (Panel)((Component)((MenuComponent)((PopupMenu)((MenuItem)e.getSource()).getParent())).getParent()).getParent().getParent();
            Component[] components = panel.getComponents();
            int j = 0;
            while (j < components.length) {
                if (components[j] instanceof Panel) {
                    Component[] subComponents = ((Panel)components[j]).getComponents();
                    int k = 1;
                    while (k < subComponents.length) {
                        subComponents[k].setVisible(!subComponents[k].isVisible());
                        ++k;
                    }
                }
                ++j;
            }
            Container frame = panel;
            while (!(frame instanceof Frame)) {
                frame = frame.getParent();
            }
            ((Frame)frame).pack();
        } else if (e.getActionCommand().equals(FOLD_UNFOLD_OBJECT)) {
            Panel panel = (Panel)((Component)((MenuComponent)((PopupMenu)((MenuItem)e.getSource()).getParent())).getParent()).getParent().getParent();
            Component[] components = panel.getComponents();
            int j = 0;
            while (j < components.length) {
                if (components[j] instanceof Panel) {
                    boolean doesContainObject = false;
                    Component[] subComponents = ((Panel)components[j]).getComponents();
                    int k = 1;
                    while (k < subComponents.length && !doesContainObject) {
                        doesContainObject = ((Label)subComponents[k]).getText().indexOf(" Object") > 0 || ((Label)subComponents[k]).getText().indexOf(".Object") > 0;
                        ++k;
                    }
                    if (doesContainObject) {
                        k = 1;
                        while (k < subComponents.length) {
                            subComponents[k].setVisible(!subComponents[k].isVisible());
                            ++k;
                        }
                    }
                }
                ++j;
            }
            Container frame = panel;
            while (!(frame instanceof Frame)) {
                frame = frame.getParent();
            }
            ((Frame)frame).pack();
        } else if (e.getActionCommand().equals(SHOW_HIDE)) {
            int hashCode = Integer.parseInt(sourceName);
            Drawable[] drawable = this.canvas.getBackgroundElements();
            int i = 0;
            while (i < drawable.length) {
                if (drawable[i] instanceof GroupSolution && ((GroupSolution)drawable[i]).getSolution().hashCode() == hashCode) {
                    drawable[i].setSelected(!drawable[i].isSelected());
                    this.awtCanvas.setSize(this.canvas.getDimension());
                    i = drawable.length;
                }
                ++i;
            }
        }
        this.awtCanvas.getParent().repaint();
    }
}

