/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import ptidej.solver.Solution;
import ptidej.solver.SolutionComponent;
import ptidej.ui.event.SourceEvent;
import ptidej.ui.event.SourceListener;
import ptidej.viewer.core.ConstraintSolutionsActionListener;
import ptidej.viewer.core.ConstraintViewerPanel;
import ptidej.viewer.core.Logo;
import ptidej.viewer.core.Separator;
import ptidej.viewer.core.ViewerPanel;
import ptidej.viewer.layout.VFlowLayout;
import util.awt.WindowCloser;

public final class ConstraintSolutionsFrame
extends Frame
implements SourceListener {
    private static final Label NO_SOLUTION_LABEL = new Label("No solutions found", 1);
    private final ScrollPane scrollPane;
    private final ViewerPanel parent;
    private final ConstraintSolutionsActionListener actionListener;
    private static ConstraintSolutionsFrame UniqueInstance;

    public static ConstraintSolutionsFrame getConstraintResultFrame(ViewerPanel parent, ConstraintSolutionsActionListener actionListener) {
        if (UniqueInstance == null) {
            UniqueInstance = new ConstraintSolutionsFrame(parent, actionListener);
        }
        UniqueInstance.show();
        return UniqueInstance;
    }

    private ConstraintSolutionsFrame(ViewerPanel parent, ConstraintSolutionsActionListener actionListener) {
        super("Constraint results");
        this.parent = parent;
        this.actionListener = actionListener;
        new WindowCloser(this);
        ((Component)this).setSize(new Dimension(300, 500));
        ((Component)this).setLocation(this.getX() + 50, this.getY() + 50);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(Logo.BYTES));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBackground(Color.lightGray);
        this.scrollPane.getHAdjustable().setUnitIncrement(20);
        this.scrollPane.getVAdjustable().setUnitIncrement(20);
        this.add(this.scrollPane);
        this.build();
    }

    /*
     * Unable to fully structure code
     */
    private void build() {
        block5: {
            block4: {
                solutions = ((ConstraintViewerPanel.Representation)this.parent.getCurrentRepresentation()).getSolutions();
                if (solutions == null || solutions.length <= 0) break block4;
                solutionPanel = new Panel(new VFlowLayout(4));
                this.scrollPane.add(solutionPanel);
                goToMenu = new PopupMenu();
                menuItem = new MenuItem("Go to");
                menuItem.addActionListener(this.actionListener);
                goToMenu.add(menuItem);
                solutionMenu = new PopupMenu();
                menuItem = new MenuItem("Show/Hide");
                menuItem.addActionListener(this.actionListener);
                solutionMenu.add(menuItem);
                menuItem = new MenuItem("Fold/Unfold");
                menuItem.addActionListener(this.actionListener);
                solutionMenu.add(menuItem);
                menuItem = new MenuItem("Fold/Unfold All");
                menuItem.addActionListener(this.actionListener);
                solutionMenu.add(menuItem);
                menuItem = new MenuItem("Fold/Unfold containing Object");
                menuItem.addActionListener(this.actionListener);
                solutionMenu.add(menuItem);
                Arrays.sort(solutions, new Comparator(){

                    public int compare(Object s1, Object s2) {
                        return ((Solution)s2).getPercentage() - ((Solution)s1).getPercentage();
                    }
                });
                buffer = new StringBuffer();
                i = 0;
                while (i < solutions.length) {
                    componentPanel = new Panel(new VFlowLayout(4));
                    componentPanel.setName(Integer.toString(solutions[i].hashCode()));
                    solutionPanel.add(componentPanel);
                    buffer.setLength(0);
                    buffer.append("Micro-architecture ");
                    buffer.append(Integer.toString(solutions[i].getNumber()));
                    buffer.append(" similar at ");
                    buffer.append(Integer.toString(solutions[i].getPercentage()));
                    buffer.append("% with ");
                    buffer.append(solutions[i].getName());
                    solutionLabel = new Label(buffer.toString());
                    solutionNumber = i;
                    solutionLabel.setForeground(Color.blue);
                    solutionLabel.addMouseListener(new MouseAdapter(){

                        public void mousePressed(MouseEvent e) {
                            if ((e.getModifiers() & 4) == 4) {
                                solutionMenu.setName(Integer.toString(solutions[solutionNumber].hashCode()));
                                solutionMenu.show(solutionLabel, e.getX(), e.getY());
                            }
                        }
                    });
                    solutionLabel.add(solutionMenu);
                    componentPanel.add(solutionLabel);
                    componentPanel.validate();
                    enumeration = solutions[i].getComponents().iterator();
                    while (enumeration.hasNext()) {
                        solutionComponent = (SolutionComponent)enumeration.next();
                        buffer.setLength(0);
                        buffer.append(solutionComponent.getName());
                        buffer.append(" = ");
                        buffer.append(solutionComponent.getValue());
                        tokenizer = new StringTokenizer(buffer.toString(), "\n");
                        if (tokenizer.countTokens() != 1) ** GOTO lbl79
                        componentLabel = new Label(buffer.toString());
                        componentLabel.addMouseListener(new MouseAdapter(){

                            public void mousePressed(MouseEvent e) {
                                if ((e.getModifiers() & 4) == 4) {
                                    goToMenu.setName(solutionComponent.getValue());
                                    goToMenu.show(ConstraintSolutionsFrame.this.scrollPane, e.getX(), e.getY());
                                }
                            }
                        });
                        componentLabel.add(goToMenu);
                        componentPanel.add(componentLabel);
                        componentPanel.validate();
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            componentLabel = new Label(tokenizer.nextToken().replaceAll("\t", "    "));
                            componentPanel.add(componentLabel);
lbl79:
                            // 2 sources

                            ** while (tokenizer.hasMoreTokens())
                        }
lbl80:
                        // 1 sources

                    }
                    if (i < solutions.length - 1) {
                        solutionPanel.add(new Separator());
                    }
                    ++i;
                }
                break block5;
            }
            this.scrollPane.add(ConstraintSolutionsFrame.NO_SOLUTION_LABEL);
        }
    }

    public void sourceStateChanged(SourceEvent sourceEvent) {
        this.scrollPane.removeAll();
        this.build();
        this.scrollPane.validate();
        this.scrollPane.repaint();
    }
}

