/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.core;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAbstractModel;
import padl.kernel.IPatternModel;
import padl.kernel.IWalker;
import padl.util.PatternRepository;
import padl.visitor.PtidejSolver3AC4DomainGenerator;
import padl.visitor.PtidejSolver3CustomDomainGenerator;
import padl.visitor.PtidejSolverDomainGenerator;
import ptidej.solver.Solution;
import ptidej.solver.SolutionBuilder;
import ptidej.solver.SolutionComponent;
import ptidej.solver.SolutionGenerator;
import ptidej.ui.Drawable;
import ptidej.ui.solution.GroupSolution;
import ptidej.ui.solution.GroupSolutionTip;
import ptidej.ui.solution.awt.PrimitiveFactory;
import ptidej.viewer.core.Button;
import ptidej.viewer.core.ConstraintSolutionsActionListener;
import ptidej.viewer.core.ConstraintSolutionsFrame;
import ptidej.viewer.core.ProjectViewerPanel;
import ptidej.viewer.core.ViewerPanel;
import util.io.ExtensionBasedFilenameFilter;

public class ConstraintViewerPanel
extends ProjectViewerPanel {
    public static final String FIND_SIMILAR_MA_TEXT = "Find similar micro-architectures";
    public static final String GENERATE_PROGRAM_MODEL = "Generate program model";
    public static final String GENERATE_SOLVER_DATA_TEXT = "Generate solver execution data";
    public static final String LIST_ALL_MA_TEXT = "List similar micro-architectures";
    public static final String LOAD_MA_TEXT = "Load similar micro-architectures";
    public static final String MODIFY_PROGRAM_MODEL_TEXT = "Modify program model";
    public static final String REMOVE_ALL_MA_TEXT = "Remove all similar micro-architectures";
    private int chosenPattern;
    private int chosenProblem = 0;
    private int chosenSolver = 0;
    private final IPatternModel[] patterns;
    private ConstraintSolutionsFrame solutionFrame;

    public ConstraintViewerPanel() {
        PatternRepository patternRepository = PatternRepository.getCurrentPatternRepository(ViewerPanel.FILE_REPOSITORY);
        this.patterns = patternRepository.listOfPatterns();
        this.addSeparator();
        this.addButton(MODIFY_PROGRAM_MODEL_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConstraintViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ConstraintViewerPanel.this.modifyStructure();
                ConstraintViewerPanel.this.displayCurrentSource();
                ConstraintViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }, false, true);
        this.addButton(REMOVE_ALL_MA_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConstraintViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ConstraintViewerPanel.this.removeAllConcretePatterns();
                ConstraintViewerPanel.this.displayCurrentSource();
                ConstraintViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }, false, true);
        this.addButton(LOAD_MA_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConstraintViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ConstraintViewerPanel.this.loadConstraintsInformation();
                ConstraintViewerPanel.this.displayCurrentSource();
                ConstraintViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }, false, true);
        this.addButton(FIND_SIMILAR_MA_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConstraintViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ConstraintViewerPanel.this.callConstraintSolver();
                ConstraintViewerPanel.this.displayCurrentSource();
                ConstraintViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }, false, true);
        this.addButton(GENERATE_SOLVER_DATA_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConstraintViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ConstraintViewerPanel.this.generateExecutionInformation();
                ConstraintViewerPanel.this.displayCurrentSource();
                ConstraintViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }, false, true);
        this.addButton(GENERATE_PROGRAM_MODEL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConstraintViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ConstraintViewerPanel.this.generatePtidejModel();
                ConstraintViewerPanel.this.displayCurrentSource();
                ConstraintViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }, false, true);
        final String[] checkboxesTexts = new String[]{"Custom problem", "AC-4 problem", "Simple automatic solver", "Combinatorial automatic solver", "Automatic solver"};
        Checkbox[] checkboxes = new Checkbox[checkboxesTexts.length];
        CheckboxGroup problemGroup = new CheckboxGroup();
        CheckboxGroup solverGroup = new CheckboxGroup();
        ItemListener itemListener = new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                String cmd = (String)e.getItem();
                if (cmd.equals(checkboxesTexts[0])) {
                    ConstraintViewerPanel.this.chosenProblem = 0;
                } else if (cmd.equals(checkboxesTexts[1])) {
                    ConstraintViewerPanel.this.chosenProblem = 1;
                } else if (cmd.equals(checkboxesTexts[2])) {
                    ConstraintViewerPanel.this.chosenSolver = 2;
                } else if (cmd.equals(checkboxesTexts[3])) {
                    ConstraintViewerPanel.this.chosenSolver = 1;
                } else if (cmd.equals(checkboxesTexts[4])) {
                    ConstraintViewerPanel.this.chosenSolver = 0;
                }
            }
        };
        int i = 0;
        while (i < 2) {
            checkboxes[i] = new Checkbox(checkboxesTexts[i], problemGroup, true);
            checkboxes[i].addItemListener(itemListener);
            this.addWidget(checkboxes[i]);
            ++i;
        }
        i = 2;
        while (i < checkboxes.length) {
            checkboxes[i] = new Checkbox(checkboxesTexts[i], solverGroup, true);
            checkboxes[i].addItemListener(itemListener);
            this.addWidget(checkboxes[i]);
            ++i;
        }
        problemGroup.setSelectedCheckbox(checkboxes[0]);
        solverGroup.setSelectedCheckbox(checkboxes[4]);
        this.addWidget(this.buildPatternChoice());
        Button button = new Button(LIST_ALL_MA_TEXT);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConstraintViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ConstraintViewerPanel.this.displaySolutions();
                ConstraintViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        button.setEnabled(false);
        this.addSourceListener(button);
        this.addWidget(button);
    }

    private Choice buildPatternChoice() {
        Choice patternChoice = new Choice();
        int i = 0;
        while (i < this.patterns.length) {
            patternChoice.addItem(this.patterns[i].getName());
            ++i;
        }
        patternChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ConstraintViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ConstraintViewerPanel.this.chosenPattern = ((Choice)itemEvent.getSource()).getSelectedIndex();
                ConstraintViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        return patternChoice;
    }

    private void callConstraintSolver() {
        if (this.getCurrentSourceModel() instanceof IAbstractLevelModel) {
            SolutionGenerator solutionGenerator = SolutionGenerator.getCurrentSolutionGenerator();
            Properties solutions = solutionGenerator.getSolutions(this.getCurrentPatternName(), (IAbstractModel)((IAbstractLevelModel)this.getCurrentSourceModel()), this.chosenSolver, this.chosenProblem);
            this.loadConstraintsInformation(solutions);
        }
    }

    protected ptidej.ui.Representation createNewRepresentation() {
        return new Representation();
    }

    private void displaySolutions() {
        ConstraintSolutionsActionListener actionListener = new ConstraintSolutionsActionListener(this.getCurrentCanvas(), this.getCurrentAWTCanvas(), this.getCurrentSourceGraph());
        if (this.solutionFrame == null) {
            this.solutionFrame = ConstraintSolutionsFrame.getConstraintResultFrame(this, actionListener);
            this.addSourceListener(this.solutionFrame);
        } else {
            this.dispatchSourceChange();
            this.solutionFrame.show();
        }
    }

    private void generateExecutionInformation() {
        if (this.getCurrentSourceModel() instanceof IAbstractLevelModel) {
            SolutionGenerator solutionGenerator = SolutionGenerator.getCurrentSolutionGenerator();
            IPatternModel chosenPattern = this.getCurrentPattern();
            solutionGenerator.generateExecutionInformation(chosenPattern.getName(), chosenPattern, (IAbstractLevelModel)this.getCurrentSourceModel(), this.chosenSolver, this.chosenProblem);
        }
    }

    private void generatePtidejModel() {
        PtidejSolverDomainGenerator generator = this.chosenProblem == 1 ? new PtidejSolver3AC4DomainGenerator() : new PtidejSolver3CustomDomainGenerator();
        this.getCurrentSourceModel().walk((IWalker)((Object)generator));
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        fileDialog.setMode(1);
        ((Dialog)fileDialog).setTitle("Save model to...");
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            String destinationFile = String.valueOf(fileDialog.getDirectory()) + File.separatorChar + fileDialog.getFile();
            try {
                FileWriter writer = new FileWriter(destinationFile);
                writer.write(generator.getResult().toString());
                writer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public String getAppInfo() {
        return "Ptidej UI Viewer (ConstraintViewer) v0.94";
    }

    private IPatternModel getCurrentPattern() {
        return this.patterns[this.chosenPattern];
    }

    private String getCurrentPatternName() {
        return this.getCurrentPattern().getName();
    }

    private String[] getParameters(String xCommand) {
        String param = "";
        if (xCommand.indexOf(124) > -1) {
            param = xCommand.substring(0, xCommand.indexOf(124));
        }
        StringTokenizer tokenizer = new StringTokenizer(param, ",");
        String[] parameters = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = tokenizer.nextToken().trim();
            ++i;
        }
        return parameters;
    }

    protected void loadConstraintsInformation() {
        try {
            FileDialog fileDialog = new FileDialog((Frame)this.getParent());
            ((Dialog)fileDialog).setTitle("Choose constraints result file");
            fileDialog.setFilenameFilter(new ExtensionBasedFilenameFilter(".ini"));
            fileDialog.setFile("*.ini");
            fileDialog.setModal(true);
            fileDialog.show();
            if (fileDialog.getFile() != null) {
                Properties solutions = new Properties();
                solutions.load(new FileInputStream(String.valueOf(fileDialog.getDirectory()) + File.separatorChar + fileDialog.getFile()));
                this.loadConstraintsInformation(solutions);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void loadConstraintsInformation(Properties properties) {
        SolutionBuilder builder = SolutionBuilder.getCurrentSolutionBuilder();
        Solution[] solutions = builder.getCanonicalSolutions(properties, this.getCurrentSourceModel());
        ((Representation)this.getCurrentRepresentation()).setSolutions(solutions);
        GroupSolution[] groupSolutions = new GroupSolution[solutions.length];
        int i = groupSolutions.length - 1;
        while (i >= 0) {
            groupSolutions[i] = new GroupSolution(this.getCurrentCanvas(), (PrimitiveFactory)this.getPrimitiveFactory(), solutions[i], builder, this.getCurrentSourceGraph());
            groupSolutions[i].build();
            if (groupSolutions[i].isShowable()) {
                this.getCurrentCanvas().addToBackground(groupSolutions[i]);
            }
            --i;
        }
        this.dispatchSourceChange();
    }

    protected void modifyStructure() {
        Drawable[] drawables = this.getCurrentCanvas().getBackgroundElements();
        ArrayList<Drawable> allSolutions = new ArrayList<Drawable>();
        int i = 0;
        while (i < drawables.length) {
            if (drawables[i] instanceof GroupSolution) {
                allSolutions.add(drawables[i]);
            }
            ++i;
        }
        GroupSolution[] groupSolutions = new GroupSolution[allSolutions.size()];
        allSolutions.toArray(groupSolutions);
        boolean isSelected = false;
        int selected = 0;
        while (selected < groupSolutions.length && !(isSelected = groupSolutions[selected].isSelected())) {
            ++selected;
        }
        if (isSelected) {
            String xCommand = "";
            SolutionComponent xCommandComponent = groupSolutions[selected].getSolution().getComponent("XCommand");
            if (xCommandComponent != null) {
                xCommand = xCommandComponent.getValue();
            }
            String[] parameters = this.getParameters(xCommand);
            this.getCurrentCanvas().removeFromBackground(groupSolutions[selected]);
            drawables = this.getCurrentCanvas().getForegroundElements();
            int i2 = 0;
            while (i2 < drawables.length) {
                if (drawables[i2] instanceof GroupSolutionTip) {
                    this.getCurrentCanvas().removeFromForeground((GroupSolutionTip)drawables[i2]);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < groupSolutions.length) {
                boolean isRelated = true;
                isRelated &= groupSolutions[i2].getPercentage() == groupSolutions[selected].getPercentage();
                int j = 0;
                while (j < parameters.length) {
                    isRelated = groupSolutions[i2].getSolution().getComponent(parameters[j]) != null ? (isRelated &= groupSolutions[i2].getSolution().getComponent(parameters[j]).getValue().equals(groupSolutions[selected].getSolution().getComponent(parameters[j]).getValue())) : false;
                    ++j;
                }
                if (parameters.length != 0 && isRelated) {
                    this.getCurrentCanvas().removeFromBackground(groupSolutions[i2]);
                }
                ++i2;
            }
        }
    }

    private void removeAllConcretePatterns() {
        Drawable[] drawables = this.getCurrentCanvas().getBackgroundElements();
        int i = 0;
        while (i < drawables.length) {
            if (drawables[i] instanceof GroupSolution) {
                this.getCurrentCanvas().removeFromBackground(drawables[i]);
            }
            ++i;
        }
        drawables = this.getCurrentCanvas().getForegroundElements();
        i = 0;
        while (i < drawables.length) {
            if (drawables[i] instanceof GroupSolutionTip) {
                this.getCurrentCanvas().removeFromForeground(drawables[i]);
            }
            ++i;
        }
        ((Representation)this.getCurrentRepresentation()).setSolutions(null);
        this.dispatchSourceChange();
    }

    protected final class Representation
    extends ProjectViewerPanel.Representation {
        private Solution[] solutions;

        protected Representation() {
        }

        public Solution[] getSolutions() {
            return this.solutions;
        }

        public void setSolutions(Solution[] solutions) {
            this.solutions = solutions;
        }
    }
}

