/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.util.Iterator;
import java.util.Map;
import ptidej.ui.event.SourceEvent;
import ptidej.ui.event.SourceListener;
import ptidej.viewer.core.Logo;
import ptidej.viewer.core.MetricResultsActionListener;
import ptidej.viewer.core.MetricViewerPanel;
import ptidej.viewer.core.Separator;
import ptidej.viewer.core.ViewerPanel;
import ptidej.viewer.layout.VFlowLayout;
import util.awt.WindowCloser;

public final class MetricResultsFrame
extends Frame
implements SourceListener {
    private static final Label NO_SOLUTION_LABEL = new Label("No metric computed", 1);
    private final ScrollPane scrollPane;
    private final ViewerPanel parent;
    private final MetricResultsActionListener actionListener;
    private static MetricResultsFrame UniqueInstance;

    public static MetricResultsFrame getMetricsResultFrame(ViewerPanel parent, MetricResultsActionListener actionListener) {
        if (UniqueInstance == null) {
            UniqueInstance = new MetricResultsFrame(parent, actionListener);
        }
        UniqueInstance.show();
        return UniqueInstance;
    }

    private MetricResultsFrame(ViewerPanel parent, MetricResultsActionListener actionListener) {
        super("Metrics results");
        this.parent = parent;
        this.actionListener = actionListener;
        new WindowCloser(this);
        ((Component)this).setSize(new Dimension(300, 500));
        ((Component)this).setLocation(this.getX() + 50, this.getY() + 50);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(Logo.BYTES));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBackground(Color.lightGray);
        this.scrollPane.getHAdjustable().setUnitIncrement(20);
        this.scrollPane.getVAdjustable().setUnitIncrement(20);
        this.add(this.scrollPane);
        this.build();
    }

    private void build() {
        Map metricsValues = ((MetricViewerPanel.Representation)this.parent.getCurrentRepresentation()).getMetricsValues();
        if (metricsValues.size() > 0) {
            Panel solutionPanel = new Panel(new VFlowLayout(4));
            this.scrollPane.add(solutionPanel);
            Iterator iterator = metricsValues.keySet().iterator();
            StringBuffer buffer = new StringBuffer();
            while (iterator.hasNext()) {
                Panel componentPanel = new Panel(new VFlowLayout(4));
                solutionPanel.add(componentPanel);
                Object metricName = iterator.next();
                Object metricValue = metricsValues.get(metricName);
                buffer.setLength(0);
                buffer.append("Metric ");
                buffer.append(metricName);
                buffer.append(" = ");
                buffer.append(metricValue);
                Label componentLabel = new Label(buffer.toString());
                componentLabel.setForeground(Color.blue);
                componentPanel.add(componentLabel);
                if (!iterator.hasNext()) continue;
                solutionPanel.add(new Separator());
            }
        } else {
            this.scrollPane.add(NO_SOLUTION_LABEL);
        }
    }

    public void sourceStateChanged(SourceEvent sourceEvent) {
        this.scrollPane.removeAll();
        this.build();
        this.scrollPane.validate();
        this.scrollPane.repaint();
    }
}

