/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.core;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import padl.kernel.IWalker;
import padl.util.VisitorRepository;
import ptidej.viewer.core.MetricResultsActionListener;
import ptidej.viewer.core.MetricResultsFrame;
import ptidej.viewer.core.ProjectViewerPanel;
import ptidej.viewer.core.ViewerPanel;

public class MetricViewerPanel
extends ProjectViewerPanel {
    private MetricResultsFrame resultsFrame;

    public MetricViewerPanel() {
        this.addSeparator();
        this.addButton("Show results", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetricViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                MetricViewerPanel.this.displayResults();
                MetricViewerPanel.this.displayCurrentSource();
                MetricViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }, false, true);
        this.addButton("Compute metrics", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetricViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                MetricViewerPanel.this.computeMetrics();
                MetricViewerPanel.this.displayCurrentSource();
                MetricViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }, false, true);
    }

    private void computeMetrics() {
        Representation representation = (Representation)this.getCurrentRepresentation();
        representation.resetMetricsValues();
        IWalker[] listOfWalkers = VisitorRepository.getCurrentVisitorRepository(ViewerPanel.FILE_REPOSITORY).listOfWalkers();
        int i = 0;
        while (i < listOfWalkers.length) {
            String metricName = listOfWalkers[i].getClass().getName();
            if (metricName.indexOf(".Metric") == metricName.lastIndexOf(46)) {
                this.getCurrentSourceModel().walk(listOfWalkers[i]);
                representation.addMetricValue(listOfWalkers[i].getName(), listOfWalkers[i].getResult());
            }
            ++i;
        }
        this.dispatchSourceChange();
    }

    protected ptidej.ui.Representation createNewRepresentation() {
        return new Representation();
    }

    private void displayResults() {
        MetricResultsActionListener actionListener = new MetricResultsActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        if (this.resultsFrame == null) {
            this.resultsFrame = MetricResultsFrame.getMetricsResultFrame(this, actionListener);
            this.addSourceListener(this.resultsFrame);
        } else {
            this.dispatchSourceChange();
            this.resultsFrame.show();
        }
    }

    public String getAppInfo() {
        return "Ptidej UI Viewer (MetricsViewer) v0.1";
    }

    protected class Representation
    extends ProjectViewerPanel.Representation {
        private Map metricsValues = new HashMap();

        public Representation() {
            super(MetricViewerPanel.this);
        }

        public void addMetricValue(String metricName, Object metricValue) {
            this.metricsValues.put(metricName, metricValue);
        }

        public Map getMetricsValues() {
            return this.metricsValues;
        }

        public void resetMetricsValues() {
            this.metricsValues.clear();
        }
    }
}

