/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.core;

import com.ibm.toad.cfparse.ClassFile;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import padl.creator.ClassFileCompleteCreator;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IEntity;
import padl.kernel.IIdiomLevelModel;
import padl.kernel.IIdiomLevelModelCreator;
import padl.kernel.IPatternModel;
import padl.kernel.impl.v2.Factory;
import padl.util.PatternRepository;
import ptidej.viewer.core.ViewerPanel;
import util.PropertyManager;
import util.io.SubtypeLoader;

public final class PatternSolutionsViewerPanel
extends ViewerPanel {
    public PatternSolutionsViewerPanel() {
        this.build();
    }

    public String getAppInfo() {
        return "Ptidej UI Viewer (SV) v0.1";
    }

    private void build() {
        IIdiomLevelModel aPI = Factory.getUniqueInstance().createIdiomLevelModel("Solution");
        try {
            ClassFile[] listOfTestsTypes = SubtypeLoader.loadSubtypesFromDir(null, String.valueOf(PropertyManager.getTestsDirectory()) + PropertyManager.getTestsPackage().replace('.', '/') + '/', PropertyManager.getTestsExtension());
            aPI.create((IIdiomLevelModelCreator)new ClassFileCompleteCreator(ViewerPanel.FILE_REPOSITORY, listOfTestsTypes));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PatternRepository patternsRepository = PatternRepository.getCurrentPatternRepository(ViewerPanel.FILE_REPOSITORY);
        Map tempSolutions = aPI.compare(patternsRepository);
        IPatternModel[] realPatterns = patternsRepository.listOfPatterns();
        try {
            int i = 0;
            while (i < realPatterns.length) {
                List patternSolutions = (List)tempSolutions.get(realPatterns[i].getName());
                if (patternSolutions != null && patternSolutions.size() > 0) {
                    this.addSource(realPatterns[i], String.valueOf(realPatterns[i].getName()) + " - Initial");
                    int j = 0;
                    while (j < patternSolutions.size()) {
                        IAbstractLevelModel onePattern = null;
                        onePattern = (IAbstractLevelModel)realPatterns[i].clone();
                        Map oneSolution = (Map)patternSolutions.get(j);
                        Iterator iterator = oneSolution.keySet().iterator();
                        while (iterator.hasNext()) {
                            String currentActorName = (String)iterator.next();
                            List equivalentRealActors = (List)oneSolution.get(currentActorName);
                            onePattern.getActorFromName(currentActorName).setName(((IEntity)equivalentRealActors.get(0)).getName());
                        }
                        this.addSource(onePattern, String.valueOf(onePattern.getName()) + " - " + (j + 1));
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
    }
}

