/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.core;

import com.ibm.toad.cfparse.ClassFile;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import padl.creator.AOLCreator;
import padl.creator.ClassFileCompleteCreator;
import padl.creator.CppCreator;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IIdiomLevelModel;
import padl.kernel.IIdiomLevelModelCreator;
import padl.kernel.ListenerManager;
import padl.kernel.impl.v2.Factory;
import padl.util.ModelStatistics;
import ptidej.core.ExtraInformationProcessor;
import ptidej.ui.solution.awt.PrimitiveFactory;
import ptidej.viewer.core.ViewerPanel;
import util.PropertyManager;
import util.awt.NameDialog;
import util.io.ExtensionBasedFilenameFilter;
import util.io.SubtypeLoader;

public class ProjectViewerPanel
extends ViewerPanel {
    public static final String ADD_AOL_FILE_TEXT = "Add AOL file (.aol)";
    public static final String ADD_CPP_FILE_TEXT = "Add C++ file (.cpp)";
    public static final String ADD_JAR_FILE_TEXT = "Add JAR file (.jar)";
    public static final String ADD_JAVA_FILE_TEXT = "Add Java file (.class)";
    public static final String ADD_JAVA_PACKAGE_TEXT = "Add Java package (.class)";
    public static final String CREATE_NEW_PROJECT_TEXT = "Create Ptidej project";
    public static final String LOAD_EXTRINSIC_DATA_TEXT = "Load extrinsic data";
    public static final String LOAD_PTIDEJ_PROJECT_TEXT = "Load Ptidej project";
    public static final String SAVE_PROJECT_TEXT = "Save Ptidej project";

    public ProjectViewerPanel() {
        this.addSeparator();
        this.addButton(SAVE_PROJECT_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ProjectViewerPanel.this.saveProject();
                ProjectViewerPanel.this.displayCurrentSource();
                ProjectViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }, false, true);
        this.addButton(ADD_AOL_FILE_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ProjectViewerPanel.this.addAOLFile();
                ProjectViewerPanel.this.displayCurrentSource();
                ProjectViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addButton(ADD_CPP_FILE_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ProjectViewerPanel.this.addCppFile();
                ProjectViewerPanel.this.displayCurrentSource();
                ProjectViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addButton(ADD_JAVA_PACKAGE_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ProjectViewerPanel.this.addJavaPackage();
                ProjectViewerPanel.this.displayCurrentSource();
                ProjectViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addButton(ADD_JAR_FILE_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ProjectViewerPanel.this.addJarFile();
                ProjectViewerPanel.this.displayCurrentSource();
                ProjectViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addButton(ADD_JAVA_FILE_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ProjectViewerPanel.this.addJavaFile();
                ProjectViewerPanel.this.displayCurrentSource();
                ProjectViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addButton(LOAD_EXTRINSIC_DATA_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ProjectViewerPanel.this.loadExtraInformation();
                ProjectViewerPanel.this.displayCurrentSource();
                ProjectViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }, false, true);
        this.addButton(LOAD_PTIDEJ_PROJECT_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ProjectViewerPanel.this.loadProject();
                ProjectViewerPanel.this.displayCurrentSource();
                ProjectViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addButton(CREATE_NEW_PROJECT_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ProjectViewerPanel.this.createProject();
                ProjectViewerPanel.this.displayCurrentSource();
                ProjectViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    private void addAOLFile() {
        this.createProject();
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        ((Dialog)fileDialog).setTitle("Choose an AOL file to load");
        fileDialog.setFilenameFilter(new ExtensionBasedFilenameFilter(".aol"));
        fileDialog.setMode(0);
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        IIdiomLevelModel idiomLevelModel = (IIdiomLevelModel)this.getCurrentRepresentation().getSourceModel();
        idiomLevelModel.removeAllActors();
        idiomLevelModel.create((IIdiomLevelModelCreator)new AOLCreator((String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile()).replace('\\', PropertyManager.getSeparatorChar())));
        this.setCurrentSourceModel(idiomLevelModel);
    }

    private void addCppFile() {
        this.createProject();
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        ((Dialog)fileDialog).setTitle("Choose an C++ file to load");
        fileDialog.setFilenameFilter(new ExtensionBasedFilenameFilter(".cpp"));
        fileDialog.setMode(0);
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        IIdiomLevelModel idiomLevelModel = (IIdiomLevelModel)this.getCurrentRepresentation().getSourceModel();
        idiomLevelModel.removeAllActors();
        idiomLevelModel.create((IIdiomLevelModelCreator)new CppCreator((String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile()).replace('\\', PropertyManager.getSeparatorChar())));
        this.setCurrentSourceModel(idiomLevelModel);
    }

    private void addJarFile() {
        if (this.getCurrentRepresentation() == null && !this.createProject()) {
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        ((Dialog)fileDialog).setTitle("Choose a jar file to add");
        fileDialog.setFilenameFilter(new ExtensionBasedFilenameFilter(".jar"));
        fileDialog.setMode(0);
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        ((Representation)this.getCurrentRepresentation()).addPath((String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile()).replace('\\', PropertyManager.getSeparatorChar()));
        this.build();
    }

    private void addJavaFile() {
        if (this.getCurrentRepresentation() == null && !this.createProject()) {
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        ((Dialog)fileDialog).setTitle("Choose a class file to add");
        fileDialog.setFilenameFilter(new ExtensionBasedFilenameFilter(".class"));
        fileDialog.setMode(0);
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        ((Representation)this.getCurrentRepresentation()).addPath((String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile()).replace('\\', PropertyManager.getSeparatorChar()));
        this.build();
    }

    private void addJavaPackage() {
        if (this.getCurrentRepresentation() == null && !this.createProject()) {
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        ((Dialog)fileDialog).setTitle("Choose an entity from the package to add");
        fileDialog.setFilenameFilter(new ExtensionBasedFilenameFilter(".class"));
        fileDialog.setMode(0);
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        ((Representation)this.getCurrentRepresentation()).addPath(fileDialog.getDirectory().replace('\\', PropertyManager.getSeparatorChar()));
        this.build();
    }

    private void build() {
        IIdiomLevelModel idiomLevelModel = (IIdiomLevelModel)this.getCurrentRepresentation().getSourceModel();
        System.gc();
        long total1 = Runtime.getRuntime().totalMemory();
        long freem1 = Runtime.getRuntime().freeMemory();
        idiomLevelModel.removeAllActors();
        Iterator dirsAndJars = ((Representation)this.getCurrentRepresentation()).getPaths().iterator();
        ClassFile[] allClassFiles = null;
        while (dirsAndJars.hasNext()) {
            String path = (String)dirsAndJars.next();
            System.out.print("Loading class files in: ");
            System.out.println(path);
            ClassFile[] classFiles = path.endsWith(".jar") ? SubtypeLoader.loadSubtypesFromJar(null, path, ".class") : (path.endsWith(".class") ? SubtypeLoader.loadSubtypeFromFile(null, path, ".class") : SubtypeLoader.loadSubtypesFromDir(null, path, ".class"));
            if (allClassFiles == null) {
                allClassFiles = classFiles;
                continue;
            }
            ClassFile[] temp = new ClassFile[allClassFiles.length + classFiles.length];
            System.arraycopy(allClassFiles, 0, temp, 0, allClassFiles.length);
            System.arraycopy(classFiles, 0, temp, allClassFiles.length, classFiles.length);
            allClassFiles = temp;
        }
        idiomLevelModel.create((IIdiomLevelModelCreator)new ClassFileCompleteCreator(ViewerPanel.FILE_REPOSITORY, allClassFiles));
        System.gc();
        long total2 = Runtime.getRuntime().totalMemory();
        long freem2 = Runtime.getRuntime().freeMemory();
        this.setCurrentSourceModel(idiomLevelModel);
        System.gc();
        long total3 = Runtime.getRuntime().totalMemory();
        long freem3 = Runtime.getRuntime().freeMemory();
        System.out.print("\nStatistics:\n");
        System.out.println(((Representation)this.getCurrentRepresentation()).getPatternStatistics());
        System.out.println("              Total memory\tFree memory");
        System.out.print("Before build  ");
        System.out.print(total1);
        System.out.print("\t\t");
        System.out.print(freem1);
        System.out.print("\t\t");
        System.out.print(total1 - freem1);
        System.out.println();
        System.out.print("After build   ");
        System.out.print(total2);
        System.out.print("\t\t");
        System.out.print(freem2);
        System.out.print("\t\t");
        System.out.print(total2 - freem2);
        System.out.println();
        System.out.print("After display ");
        System.out.print(total3);
        System.out.print("\t\t");
        System.out.print(freem3);
        System.out.print("\t\t");
        System.out.print(total2 - freem3);
        System.out.println();
    }

    protected ptidej.ui.Representation createNewRepresentation() {
        return new Representation();
    }

    private boolean createProject() {
        String projectName = new NameDialog((Frame)this.getParent(), "Please, enter a project name:").getName().trim();
        if (projectName.length() > 0) {
            this.createProject(projectName);
            return true;
        }
        return false;
    }

    private void createProject(String projectName) {
        IIdiomLevelModel patternIntrospector = Factory.getUniqueInstance().createIdiomLevelModel(projectName);
        if (this.getCurrentRepresentation() != null) {
            ModelStatistics oldPatternStatistics = ((Representation)this.getCurrentRepresentation()).getPatternStatistics();
            ListenerManager.getCurrentListenerManager().removeModelListener(oldPatternStatistics);
        }
        ModelStatistics newPatternStatistics = new ModelStatistics();
        ListenerManager.getCurrentListenerManager().addModelListener(newPatternStatistics);
        this.addSource(patternIntrospector, patternIntrospector.getName());
        ((Representation)this.getCurrentRepresentation()).setPatternStatistics(newPatternStatistics);
        this.getCurrentRepresentation().setSourceModel(patternIntrospector);
    }

    public String getAppInfo() {
        return "Ptidej UI Viewer (ProjectLoader) v0.6";
    }

    protected ptidej.ui.primitive.PrimitiveFactory getPrimitiveFactory() {
        return PrimitiveFactory.getPrimitiveFactory();
    }

    protected void loadExtraInformation() {
        Properties properties = new Properties();
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        ((Dialog)fileDialog).setTitle("Choose extra information to load");
        fileDialog.setFilenameFilter(new ExtensionBasedFilenameFilter(".pdl"));
        fileDialog.setFile("*.pdl");
        fileDialog.setMode(0);
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        String fileName = fileDialog.getFile();
        if (fileName != null) {
            try {
                properties.load(new FileInputStream(String.valueOf(fileDialog.getDirectory()) + File.separatorChar + fileName));
                IAbstractLevelModel pattern = (IAbstractLevelModel)this.getCurrentSourceModel();
                ExtraInformationProcessor.process(properties, pattern);
                this.setCurrentSourceModel(pattern);
                this.displayCurrentSource();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.dispatchSourceChange();
    }

    protected void loadProject() {
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        ((Dialog)fileDialog).setTitle("Choose a project to load");
        fileDialog.setFilenameFilter(new ExtensionBasedFilenameFilter(".ptidej"));
        fileDialog.setFile("*.ptidej");
        fileDialog.setMode(0);
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.createProject(p.getProperty("Name"));
        long startingTime = System.currentTimeMillis();
        StringTokenizer classpath = new StringTokenizer(p.getProperty("Classpath"), ";");
        while (classpath.hasMoreTokens()) {
            String path = classpath.nextToken();
            if (!new File(path).exists()) {
                path = String.valueOf(fileDialog.getDirectory()) + path;
            }
            path = path.replace('\\', PropertyManager.getSeparatorChar());
            ((Representation)this.getCurrentRepresentation()).addPath(path);
        }
        this.build();
        long endingTime = System.currentTimeMillis();
        System.out.print("Loading time: ");
        System.out.print(endingTime - startingTime);
        System.out.println(" ms.\n");
    }

    private void saveProject() {
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        ((Dialog)fileDialog).setTitle("Choose a project file");
        fileDialog.setFilenameFilter(new ExtensionBasedFilenameFilter(".ptidej"));
        fileDialog.setMode(1);
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(String.valueOf(fileDialog.getDirectory()) + File.separatorChar + fileDialog.getFile());
            try {
                try {
                    fileWriter.write("[Ptidej Project]\n");
                    fileWriter.write("Name = ");
                    fileWriter.write(this.getCurrentRepresentation().getSourceModel().getName());
                    fileWriter.write(10);
                    fileWriter.write("Classpath = ");
                    Iterator iterator = ((Representation)this.getCurrentRepresentation()).getPaths().iterator();
                    while (iterator.hasNext()) {
                        fileWriter.write((String)iterator.next());
                        if (!iterator.hasNext()) continue;
                        fileWriter.write(59);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                fileWriter.close();
                throw throwable;
            }
            Object var4_8 = null;
            fileWriter.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected class Representation
    extends ViewerPanel.Representation {
        private List listOfPaths = new ArrayList();
        private ModelStatistics patternStatistics;

        protected Representation() {
        }

        public void addPath(String path) {
            this.listOfPaths.add(path);
        }

        public List getPaths() {
            return this.listOfPaths;
        }

        public ModelStatistics getPatternStatistics() {
            return this.patternStatistics;
        }

        public void setPatternStatistics(ModelStatistics patternStatistics) {
            this.patternStatistics = patternStatistics;
        }
    }
}

