/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.core;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import padl.IFileRepository;
import padl.analysis.Analysis;
import padl.analysis.Repository;
import padl.kernel.IAbstractModel;
import padl.util.DefaultFileRepository;
import ptidej.ui.Canvas;
import ptidej.ui.Constants;
import ptidej.ui.Drawable;
import ptidej.ui.VisibilityElement;
import ptidej.ui.event.SourceEvent;
import ptidej.ui.event.SourceListener;
import ptidej.ui.extension.Extension;
import ptidej.ui.kernel.GraphicModel;
import ptidej.ui.layout.InheritanceClusterLayout;
import ptidej.ui.primitive.PrimitiveFactory;
import ptidej.viewer.core.AWTCanvas;
import ptidej.viewer.core.Button;
import ptidej.viewer.core.Logo;
import ptidej.viewer.core.Separator;
import ptidej.viewer.layout.PercentLayout;
import ptidej.viewer.layout.VFlowLayout;
import ptidej.viewer.printing.CanvasVista;

public abstract class ViewerPanel
extends Panel {
    public static final String ABOUT_TEXT = "About";
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    public static final String EXIT_TEXT = "Exit";
    protected static final IFileRepository FILE_REPOSITORY = DefaultFileRepository.getDefaultFileRepository();
    private static final String NO_PROJECT_TEXT = "No Ptidej project";
    public static final String PRINT_TEXT = "Print";
    private Panel buttonPanel;
    private int currentVisibility;
    private ptidej.ui.Representation[] multiRepresentation = new Representation[4];
    private int nbOfSources;
    private BufferedZoomableScrollPane scrollPane;
    private Choice sourceChoice;
    private List sourceListeners = new ArrayList(1);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected ViewerPanel() {
        Repository analysisRepository;
        Analysis[] analyses;
        Class<?> clazz;
        ptidej.ui.extension.Repository extensionRepository;
        Extension[] extensions;
        this.setLayout(new PercentLayout());
        Panel centerPanel = new Panel(new BorderLayout());
        this.scrollPane = new BufferedZoomableScrollPane();
        centerPanel.add("Center", this.scrollPane);
        this.add((Component)centerPanel, new PercentLayout.Constraint(0.0, 0.0, 65.0, 100.0));
        this.buttonPanel = new Panel(new VFlowLayout(4));
        this.buttonPanel.setBackground(Color.lightGray);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.buttonPanel);
        scrollPane.getVAdjustable().setBlockIncrement(20);
        scrollPane.getVAdjustable().setUnitIncrement(20);
        this.add((Component)scrollPane, new PercentLayout.Constraint(65.0, 0.0, 35.0, 100.0, 200.0, 200.0));
        Label label = new Label(this.getAppInfo(), 1);
        label.setForeground(Color.blue);
        this.addWidget(label);
        ImageButton imageButton = new ImageButton(ABOUT_TEXT, Toolkit.getDefaultToolkit().createImage(Logo.BYTES));
        imageButton.setBackground(Color.lightGray);
        imageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ViewerPanel.this.displayAboutDialog();
                ViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addWidget(imageButton);
        Button exitButton = new Button(EXIT_TEXT);
        exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerPanel.this.getParent().dispatchEvent(new WindowEvent((Window)ViewerPanel.this.getParent(), 201));
            }
        });
        this.addWidget(exitButton);
        Button aboutButton = new Button(ABOUT_TEXT);
        aboutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ViewerPanel.this.displayAboutDialog();
                ViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addSourceListener(aboutButton);
        this.addWidget(aboutButton);
        Button printButton = new Button(PRINT_TEXT);
        printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ViewerPanel.this.paperPrint();
                ViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        printButton.setEnabled(false);
        this.addSourceListener(printButton);
        this.addWidget(printButton);
        this.sourceChoice = new Choice();
        this.sourceChoice.add(NO_PROJECT_TEXT);
        this.sourceChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ViewerPanel.this.displayCurrentSource();
                ViewerPanel.this.dispatchSourceChange();
                ViewerPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addWidget(this.sourceChoice);
        final String[] checkboxesTexts = new String[]{"Creation names", "Creation display", "Use names", "Use display", "Association names", "Association display", "Aggregation names", "Aggregation display", "Composition names", "Composition display", "Container Aggregation names", "Container Aggregation display", "Container Composition names", "Container Composition display", "Hierarchy names", "Hierarchy display", "Field names", "Method names", "Fully qualified names", "Ghost entities display"};
        ItemListener itemListener = new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                String cmd = (String)e.getItem();
                int stateChange = e.getStateChange();
                if (cmd.equals(checkboxesTexts[0])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x800;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFF7FF;
                    }
                } else if (cmd.equals(checkboxesTexts[1])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x1000;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFEFFF;
                    }
                } else if (cmd.equals(checkboxesTexts[2])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x80000;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFF7FFFF;
                    }
                } else if (cmd.equals(checkboxesTexts[3])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x100000;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFEFFFFF;
                    }
                } else if (cmd.equals(checkboxesTexts[4])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 4;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFFFFB;
                    }
                } else if (cmd.equals(checkboxesTexts[5])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 8;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFFFF7;
                    }
                } else if (cmd.equals(checkboxesTexts[6])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 1;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFFFFE;
                    }
                } else if (cmd.equals(checkboxesTexts[7])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 2;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFFFFD;
                    }
                } else if (cmd.equals(checkboxesTexts[8])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x10;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFFFEF;
                    }
                } else if (cmd.equals(checkboxesTexts[9])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x20;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFFFDF;
                    }
                } else if (cmd.equals(checkboxesTexts[10])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x40;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFFFBF;
                    }
                } else if (cmd.equals(checkboxesTexts[11])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x80;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFFF7F;
                    }
                } else if (cmd.equals(checkboxesTexts[12])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x100;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFFEFF;
                    }
                } else if (cmd.equals(checkboxesTexts[13])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x400;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFFBFF;
                    }
                } else if (cmd.equals(checkboxesTexts[14])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x10000;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFEFFFF;
                    }
                } else if (cmd.equals(checkboxesTexts[15])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x20000;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFDFFFF;
                    }
                } else if (cmd.equals(checkboxesTexts[16])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x2000;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFDFFF;
                    }
                } else if (cmd.equals(checkboxesTexts[17])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x40000;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFBFFFF;
                    }
                } else if (cmd.equals(checkboxesTexts[18])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x4000;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFFBFFF;
                    }
                } else if (cmd.equals(checkboxesTexts[19])) {
                    if (stateChange == 1) {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility | 0x8000;
                    } else {
                        ViewerPanel viewerPanel = ViewerPanel.this;
                        viewerPanel.currentVisibility = viewerPanel.currentVisibility & 0xFFFF7FFF;
                    }
                }
                ViewerPanel.this.displayCurrentSource();
            }
        };
        Checkbox[] checkboxes = new Checkbox[checkboxesTexts.length];
        int i = 0;
        while (i < checkboxes.length) {
            checkboxes[i] = new Checkbox(checkboxesTexts[i]);
            checkboxes[i].addItemListener(itemListener);
            this.addWidget(checkboxes[i]);
            ++i;
        }
        this.currentVisibility |= 0x20000;
        checkboxes[15].setState(true);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("ptidej.ui.extension.Repository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((extensions = (extensionRepository = ptidej.ui.extension.Repository.getCurrentExtensionManager(new DefaultFileRepository(clazz2))).getExtensions()).length > 0) {
            this.addSeparator();
            int i2 = 0;
            while (i2 < extensions.length) {
                this.addSourceListener(extensions[i2]);
                final int currentExtension = i2;
                this.addButton(extensions[i2].getName(), new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        extensions[currentExtension].invoke(ViewerPanel.this.getCurrentRepresentation());
                        ViewerPanel.this.setCursor(Cursor.getDefaultCursor());
                    }
                }, false, true);
                ++i2;
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("padl.analysis.Repository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((analyses = (analysisRepository = Repository.getCurrentAnalysisManager(new DefaultFileRepository(clazz))).getAnalyses()).length > 0) {
            this.addSeparator();
            int i3 = 0;
            while (i3 < analyses.length) {
                final int currentAnalysis = i3;
                this.addButton(analyses[i3].getName(), new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        ViewerPanel.this.addSource(analyses[currentAnalysis].analysis(ViewerPanel.this.getCurrentRepresentation().getSourceModel()));
                        ViewerPanel.this.setCursor(Cursor.getDefaultCursor());
                    }
                }, false, true);
                ++i3;
            }
        }
    }

    protected final void addButton(String buttonLabel, ActionListener listener) {
        this.addButton(buttonLabel, listener, true);
    }

    protected final void addButton(String buttonLabel, ActionListener listener, boolean isEnabled) {
        this.addButton(buttonLabel, listener, isEnabled, false);
    }

    protected final void addButton(String buttonLabel, ActionListener listener, boolean isEnabled, boolean isSourceChangeListerner) {
        Button button = new Button(buttonLabel);
        button.setEnabled(isEnabled);
        button.addActionListener(listener);
        this.addWidget(button, isSourceChangeListerner);
    }

    protected final void addSeparator() {
        this.addWidget(new Separator());
    }

    protected final void addSource(IAbstractModel abstractModel) {
        this.addSource(abstractModel, abstractModel.getName());
    }

    protected final void addSource(IAbstractModel abstractModel, String name) {
        if (this.nbOfSources == this.multiRepresentation.length) {
            ptidej.ui.Representation[] temp = new ptidej.ui.Representation[this.nbOfSources * 2];
            System.arraycopy(this.multiRepresentation, 0, temp, 0, this.nbOfSources);
            this.multiRepresentation = temp;
        }
        if (this.multiRepresentation[this.nbOfSources] == null) {
            this.multiRepresentation[this.nbOfSources] = this.createNewRepresentation();
        } else {
            this.sourceChoice.removeAll();
        }
        if (this.nbOfSources == 0) {
            this.sourceChoice.removeAll();
        }
        this.sourceChoice.add(name);
        this.sourceChoice.select(this.nbOfSources);
        ++this.nbOfSources;
        this.setCurrentSourceModel(abstractModel);
        this.displayCurrentSource();
        this.dispatchSourceChange();
    }

    protected final void addSourceListener(SourceListener sourceListener) {
        this.sourceListeners.add(sourceListener);
    }

    protected final void addWidget(Component c) {
        this.addWidget(c, false);
    }

    protected final void addWidget(Component c, boolean isSourceChangeListerner) {
        this.buttonPanel.add(c, 0);
        if (isSourceChangeListerner && c instanceof SourceListener) {
            this.addSourceListener((SourceListener)((Object)c));
        }
    }

    protected ptidej.ui.Representation createNewRepresentation() {
        return new Representation();
    }

    protected final void dispatchSourceChange() {
        int i = 0;
        while (i < this.sourceListeners.size()) {
            ((SourceListener)this.sourceListeners.get(i)).sourceStateChanged(new SourceEvent(this.getCurrentRepresentation()));
            ++i;
        }
    }

    protected void displayAboutDialog() {
        new AboutDialog((Frame)this.getParent()).show();
    }

    protected final void displayCurrentSource() {
        GraphicModel currentPattern = this.getCurrentSourceGraph();
        if (currentPattern != null) {
            currentPattern.setVisibleElements(this.currentVisibility);
            currentPattern.build();
            Canvas canvas = this.getCurrentCanvas();
            Drawable[] elements = canvas.getForegroundElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof VisibilityElement) {
                    ((VisibilityElement)((Object)elements[i])).setVisibleElements(this.currentVisibility);
                    elements[i].build();
                }
                ++i;
            }
            elements = canvas.getBackgroundElements();
            i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof VisibilityElement) {
                    ((VisibilityElement)((Object)elements[i])).setVisibleElements(this.currentVisibility);
                    elements[i].build();
                }
                ++i;
            }
            canvas.build();
        }
        if (this.getCurrentAWTCanvas() != null) {
            this.scrollPane.setComponent(this.getCurrentAWTCanvas());
            this.repaint();
        }
    }

    public abstract String getAppInfo();

    protected final AWTCanvas getCurrentAWTCanvas() {
        if (this.getCurrentRepresentation() != null) {
            return this.getCurrentRepresentation().getAWTCanvas();
        }
        return null;
    }

    protected final Canvas getCurrentCanvas() {
        return this.getCurrentAWTCanvas().getCanvas();
    }

    protected final Representation getCurrentRepresentation() {
        return (Representation)this.multiRepresentation[this.sourceChoice.getSelectedIndex()];
    }

    protected final GraphicModel getCurrentSourceGraph() {
        if (this.getCurrentRepresentation() != null) {
            return this.getCurrentRepresentation().getSourceGraph();
        }
        return null;
    }

    protected final IAbstractModel getCurrentSourceModel() {
        return this.getCurrentRepresentation().getSourceModel();
    }

    protected PrimitiveFactory getPrimitiveFactory() {
        return ptidej.ui.primitive.awt.PrimitiveFactory.getPrimitiveFactory();
    }

    public final void paint(Graphics graphics) {
        if (this.getCurrentAWTCanvas() != null) {
            this.scrollPane.setComponent(this.getCurrentAWTCanvas());
            this.repaint();
        }
        super.paint(graphics);
    }

    protected final void paperPrint() {
        if (this.getCurrentSourceGraph() != null) {
            PrinterJob pj = PrinterJob.getPrinterJob();
            PageFormat pf = new PageFormat();
            pf.setOrientation(1);
            pj.setPageable(new CanvasVista(this.getCurrentAWTCanvas(), this.getCurrentSourceModel(), this.getCurrentSourceGraph().getVisibleElements(), pf));
            try {
                if (pj.printDialog()) {
                    pj.print();
                }
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    public final void repaint() {
        this.scrollPane.validate();
        this.scrollPane.repaint();
    }

    protected final void setCurrentSourceModel(IAbstractModel abstractModel) {
        this.getCurrentRepresentation().setSourceModel(abstractModel);
        GraphicModel dPattern = new GraphicModel(this.getPrimitiveFactory(), abstractModel, new InheritanceClusterLayout());
        dPattern.build();
        this.getCurrentRepresentation().setSourceGraph(dPattern);
        AWTCanvas awtCanvas = new AWTCanvas(new Canvas((ptidej.ui.primitive.awt.PrimitiveFactory)this.getPrimitiveFactory(), dPattern));
        this.getCurrentRepresentation().setAWTCanvas(awtCanvas);
    }

    protected final class AboutDialog
    extends Dialog {
        public AboutDialog(Dialog owner) {
            this(owner, "");
        }

        public AboutDialog(Dialog owner, String title) {
            this(owner, title, false);
        }

        public AboutDialog(Dialog owner, String title, boolean modal) {
            super(owner, title, modal);
        }

        public AboutDialog(Frame owner) {
            this(owner, "");
        }

        public AboutDialog(Frame owner, boolean modal) {
            this(owner, "", modal);
        }

        public AboutDialog(Frame owner, String title) {
            this(owner, title, false);
        }

        public AboutDialog(Frame owner, String title, boolean modal) {
            super(owner, title, modal);
        }

        public void show() {
            Dimension dimension = new Dimension(550, 300);
            this.setTitle(ViewerPanel.ABOUT_TEXT);
            this.setName(ViewerPanel.ABOUT_TEXT);
            this.setModal(true);
            this.setResizable(false);
            ((Component)this).setBackground(Color.lightGray);
            ((Component)this).setLocation(new Point((Constants.SCREEN_DIMENSION.width - dimension.width) / 2, (Constants.SCREEN_DIMENSION.height - dimension.height) / 2));
            ((Component)this).setSize(dimension);
            this.addWindowListener(new AboutDialogWindowListener());
            this.setLayout(new BorderLayout());
            ScrollPane scrollPane = new ScrollPane(0);
            Panel panel = new Panel(new VFlowLayout(4, 10, 0));
            Label appInfo = new Label(ViewerPanel.this.getAppInfo());
            appInfo.setForeground(Color.BLUE);
            panel.add(appInfo);
            Color color = Color.BLACK;
            int i = 0;
            while (i < Constants.COPYRIGHT_MESSAGE.length) {
                int j = 0;
                while (j < Constants.COPYRIGHT_MESSAGE[i].length) {
                    Label label = new Label(Constants.COPYRIGHT_MESSAGE[i][j]);
                    label.setForeground(color);
                    panel.add(label);
                    ++j;
                }
                if (i == Constants.COPYRIGHT_MESSAGE.length - 2) {
                    color = Color.RED;
                }
                if (i < Constants.COPYRIGHT_MESSAGE.length - 1) {
                    panel.add(new Separator());
                }
                ++i;
            }
            scrollPane.add(panel);
            this.add("Center", scrollPane);
            super.show();
        }
    }

    protected static final class AboutDialogWindowListener
    implements WindowListener {
        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            ((Window)e.getSource()).dispose();
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    }

    private final class BufferedZoomableScrollPane
    extends ScrollPane {
        private final BufferedImage offImage;
        private double zoom = 1.0;

        public BufferedZoomableScrollPane() {
            this(0);
        }

        public BufferedZoomableScrollPane(int scrollbarDisplayPolicy) {
            super(scrollbarDisplayPolicy);
            Label dummy = new Label(ViewerPanel.NO_PROJECT_TEXT, 1);
            dummy.setBackground(BACKGROUND_COLOR);
            this.add("Center", dummy);
            this.getHAdjustable().setUnitIncrement(20);
            this.getVAdjustable().setUnitIncrement(20);
            this.offImage = new BufferedImage((int)Constants.SCREEN_DIMENSION.getWidth(), (int)Constants.SCREEN_DIMENSION.getHeight(), 1);
        }

        public int getHeight() {
            return this.getSize().height;
        }

        public int getWidth() {
            return this.getSize().width;
        }

        public void invalidate() {
            super.invalidate();
        }

        public void paint(Graphics graphics) {
            this.offImage.getGraphics().setColor(BACKGROUND_COLOR);
            this.offImage.getGraphics().fillRect(0, 0, (int)((double)this.offImage.getWidth(this) * this.zoom), (int)((double)this.offImage.getHeight(this) * this.zoom));
            ((ptidej.ui.primitive.awt.PrimitiveFactory)ViewerPanel.this.getPrimitiveFactory()).setGraphics(this.offImage.getGraphics());
            ((ptidej.ui.primitive.awt.PrimitiveFactory)ViewerPanel.this.getPrimitiveFactory()).getGraphics().translate(-((int)this.getScrollPosition().getX()), -((int)this.getScrollPosition().getY()));
            int i = 0;
            while (i < this.getComponentCount()) {
                this.getComponents()[i].paint(this.offImage.getGraphics());
                ++i;
            }
            ((ptidej.ui.primitive.awt.PrimitiveFactory)ViewerPanel.this.getPrimitiveFactory()).getGraphics().translate((int)this.getScrollPosition().getX(), (int)this.getScrollPosition().getY());
            graphics.drawImage(this.offImage, 0, 0, this);
            this.offImage.flush();
        }

        public final void repaint() {
            this.validate();
            Component awtCanvas = this.getComponent(0);
            awtCanvas.repaint();
        }

        public void setComponent(Component component) {
            this.removeAll();
            this.add("Center", component);
        }

        public void setZoom(double zoom) {
            this.zoom = zoom;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    protected static final class ImageButton
    extends Button {
        private Image image;
        private Dimension preferredSize;

        public ImageButton(String label, Image image) {
            super(label);
            this.image = image;
            this.setSize(image.getWidth(this), image.getHeight(this));
        }

        public int getHeight() {
            return this.getSize().height;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            if (this.preferredSize == null) {
                this.preferredSize = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
            }
            return this.preferredSize;
        }

        public int getWidth() {
            return this.getSize().width;
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.image, (this.getWidth() - this.image.getWidth(this)) / 2, (this.getHeight() - this.image.getHeight(this)) / 2, this);
        }
    }

    protected static class Representation
    extends ptidej.ui.Representation {
        private AWTCanvas awtCanvas;

        protected Representation() {
        }

        public AWTCanvas getAWTCanvas() {
            return this.awtCanvas;
        }

        public void setAWTCanvas(AWTCanvas awtCanvas) {
            this.awtCanvas = awtCanvas;
        }
    }
}

