/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.core;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import padl.kernel.IGenerator;
import padl.kernel.IWalker;
import padl.util.VisitorRepository;
import ptidej.viewer.core.ProjectViewerPanel;
import ptidej.viewer.core.ViewerPanel;

public class VisitorViewerPanel
extends ProjectViewerPanel {
    public VisitorViewerPanel() {
        this.addSeparator();
        VisitorRepository visitorRepository = VisitorRepository.getCurrentVisitorRepository(ViewerPanel.FILE_REPOSITORY);
        IWalker[] walkers = visitorRepository.listOfWalkers();
        int i = 0;
        while (i < walkers.length) {
            final IWalker walker = walkers[i];
            this.addButton(walker.getName(), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VisitorViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    VisitorViewerPanel.this.applyVisitor(walker);
                    VisitorViewerPanel.this.displayCurrentSource();
                    VisitorViewerPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }, false, true);
            ++i;
        }
        IGenerator[] builders = visitorRepository.listOfBuilders();
        int i2 = 0;
        while (i2 < builders.length) {
            final IGenerator builder = builders[i2];
            this.addButton(builder.getName(), new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VisitorViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    VisitorViewerPanel.this.applyVisitor(builder);
                    VisitorViewerPanel.this.displayCurrentSource();
                    VisitorViewerPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }, false, true);
            ++i2;
        }
    }

    private void applyVisitor(IGenerator builder) {
        this.getCurrentSourceModel().generate(builder);
        System.out.print("\n---- ");
        System.out.print(builder.getName());
        System.out.println(" ----");
        System.out.println(builder.getCode());
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        fileDialog.setMode(1);
        ((Dialog)fileDialog).setTitle("Save model to...");
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            String destinationFile = String.valueOf(fileDialog.getDirectory()) + File.separatorChar + fileDialog.getFile();
            try {
                FileWriter writer = new FileWriter(destinationFile);
                writer.write(builder.getCode());
                writer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void applyVisitor(IWalker walker) {
        this.getCurrentSourceModel().walk(walker);
        System.out.print("\n---- ");
        System.out.print(walker.getName());
        System.out.println(" ----");
        System.out.println(walker.getResult());
        FileDialog fileDialog = new FileDialog((Frame)this.getParent());
        fileDialog.setMode(1);
        ((Dialog)fileDialog).setTitle("Save model to...");
        fileDialog.setModal(true);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            String destinationFile = String.valueOf(fileDialog.getDirectory()) + File.separatorChar + fileDialog.getFile();
            try {
                FileWriter writer = new FileWriter(destinationFile);
                writer.write(walker.getResult().toString());
                writer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public String getAppInfo() {
        return "Ptidej UI Viewer (VV) v0.1";
    }
}

