/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Enumeration;
import java.util.Hashtable;

public class PercentLayout
implements LayoutManager2 {
    private Hashtable hash = new Hashtable();

    public float getLayoutAlignmentX(Container p1) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container p1) {
        return 0.5f;
    }

    public void addLayoutComponent(Component component, Object constraint) {
        if (!(constraint instanceof Constraint)) {
            throw new IllegalArgumentException("Invalid constraint");
        }
        this.hash.put(component, constraint);
    }

    public void addLayoutComponent(String constraint, Component comp) {
        throw new IllegalArgumentException("Invalid constraint");
    }

    public void invalidateLayout(Container p1) {
    }

    public void layoutContainer(Container p1) {
        Dimension size = p1.getSize();
        Insets insets = p1.getInsets();
        Enumeration keys = this.hash.keys();
        while (keys.hasMoreElements()) {
            Component comp = (Component)keys.nextElement();
            Constraint constraint = (Constraint)this.hash.get(comp);
            int x = (int)((double)size.width * constraint.x / 100.0);
            int y = (int)((double)size.height * constraint.y / 100.0) + insets.top;
            int width = Math.max((int)((double)size.width * constraint.width / 100.0), (int)constraint.minWidth);
            int height = Math.max((int)((double)size.height * constraint.height / 100.0) - (insets.top + insets.bottom), (int)constraint.minHeight);
            comp.setBounds(x, y, width, height);
        }
    }

    public Dimension maximumLayoutSize(Container p1) {
        int maxx = Integer.MAX_VALUE;
        int maxy = Integer.MAX_VALUE;
        Enumeration keys = this.hash.keys();
        while (keys.hasMoreElements()) {
            int my;
            Component comp = (Component)keys.nextElement();
            Constraint constraint = (Constraint)this.hash.get(comp);
            Dimension max = comp.getMaximumSize();
            int mx = max.width == Integer.MAX_VALUE ? max.width : Math.max((int)((double)(max.width * 100) / constraint.width), (int)constraint.minWidth);
            int n = my = max.height == Integer.MAX_VALUE ? max.height : Math.max((int)((double)(max.height * 100) / constraint.height), (int)constraint.minHeight);
            if (mx < maxx) {
                maxx = mx;
            }
            if (my >= maxy) continue;
            maxy = my;
        }
        return new Dimension(maxx, maxy);
    }

    public Dimension minimumLayoutSize(Container p1) {
        int minx = 0;
        int miny = 0;
        Enumeration keys = this.hash.keys();
        while (keys.hasMoreElements()) {
            Component comp = (Component)keys.nextElement();
            Constraint constraint = (Constraint)this.hash.get(comp);
            Dimension min = comp.getMinimumSize();
            int mx = Math.max((int)((double)(min.width * 100) / constraint.width), (int)constraint.minWidth);
            int my = Math.max((int)((double)(min.height * 100) / constraint.height), (int)constraint.minHeight);
            if (mx > minx) {
                minx = mx;
            }
            if (my <= miny) continue;
            miny = my;
        }
        return new Dimension(minx, miny);
    }

    public Dimension preferredLayoutSize(Container p1) {
        int prefx = 0;
        int prefy = 0;
        Enumeration keys = this.hash.keys();
        while (keys.hasMoreElements()) {
            Component comp = (Component)keys.nextElement();
            Constraint constraint = (Constraint)this.hash.get(comp);
            Dimension pref = comp.getPreferredSize();
            prefx = (int)((double)prefx + Math.max((double)(pref.width * 100) / constraint.width, (double)((int)constraint.minWidth)));
            prefy = (int)((double)prefy + Math.max((double)(pref.height * 100) / constraint.height, (double)((int)constraint.minHeight)));
        }
        int n = this.hash.size();
        return new Dimension(prefx / n, prefy / n);
    }

    public void removeLayoutComponent(Component component) {
        this.hash.remove(component);
    }

    public static class Constraint {
        double x;
        double y;
        double width;
        double height;
        double minWidth;
        double minHeight;

        public Constraint(double x, double y, double width, double height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Constraint(double x, double y, double width, double height, double minWidth, double minHeight) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.minWidth = minWidth;
            this.minHeight = minHeight;
        }
    }
}

