/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import ptidej.viewer.layout.TFlowLayout;

public class VFlowLayout
extends TFlowLayout {
    public VFlowLayout() {
        super(3, 5, 5);
    }

    public VFlowLayout(int align) {
        super(align, 5, 5);
    }

    public VFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        Dimension t = target.getSize();
        int maxheight = t.height - (insets.top + insets.bottom + this.vgap * 2);
        int roww = t.width - (insets.left + insets.right + this.hgap * 2);
        int nmembers = target.getComponentCount();
        int x = insets.left + this.hgap;
        int y = 0;
        int start = 0;
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (y == 0 || y + d.height <= maxheight) {
                    if (y > 0) {
                        y += this.vgap;
                    }
                    y += d.height;
                    roww = Math.max(roww, d.width);
                } else {
                    this.moveComponents(target, x, insets.top + this.vgap, roww, maxheight - y, start, i);
                    y = d.height;
                    x += this.hgap + roww;
                    roww = d.width;
                    start = i;
                }
            }
            ++i;
        }
        this.moveComponents(target, x, insets.top + this.vgap, roww, maxheight - y, start, nmembers);
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getMinimumSize();
                dim.width = Math.max(dim.width, d.width);
                if (i > 0) {
                    dim.height += this.vgap;
                }
                dim.height += d.height;
            }
            ++i;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getPreferredSize();
                dim.width = Math.max(dim.width, d.width);
                if (i > 0) {
                    dim.height += this.vgap;
                }
                dim.height += d.height;
            }
            ++i;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int colStart, int colEnd) {
        int extra = this.vgap;
        switch (this.align & 3) {
            case 0: {
                break;
            }
            case 4: {
                y += height / 2;
                break;
            }
            case 8: {
                y += height;
                break;
            }
            case 3: {
                int h = height / (colEnd - colStart + 1);
                extra += h;
                y += h;
            }
        }
        int i = colStart;
        while (i < colEnd) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getSize();
                int nx = x;
                switch (this.align & 0xC) {
                    case 0: {
                        nx = 0;
                        break;
                    }
                    case 1: {
                        nx += (width - d.width) / 2;
                        break;
                    }
                    case 2: {
                        nx += width - d.width;
                        break;
                    }
                    case 12: {
                        m.setSize(width, d.height);
                    }
                }
                m.setBounds(nx, y, width, d.height);
                y += extra + d.height;
            }
            ++i;
        }
    }
}

