/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.printing;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import padl.kernel.IAbstractModel;
import ptidej.ui.Canvas;
import ptidej.ui.kernel.GraphicModel;
import ptidej.ui.layout.InheritanceClusterLayout;
import ptidej.ui.primitive.awt.PrimitiveFactory;
import ptidej.viewer.core.AWTCanvas;
import ptidej.viewer.printing.Vista;

public class CanvasVista
extends Vista
implements Printable {
    private int scaleX;
    private int scaleY;
    private AWTCanvas awtCanvas;
    private IAbstractModel abstractModel;
    private int visibility;

    public CanvasVista(AWTCanvas awtCanvas, IAbstractModel abstractModel, int visibility, PageFormat format) {
        super(awtCanvas.getPreferredSize().width, awtCanvas.getPreferredSize().height, format);
        this.abstractModel = abstractModel;
        this.visibility = visibility;
        this.setCanvas(awtCanvas);
        this.setScale(1, 1);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        PrimitiveFactory primitiveFactory = new PrimitiveFactory();
        primitiveFactory.setGraphics(graphics);
        GraphicModel dPattern = new GraphicModel(primitiveFactory, this.abstractModel, new InheritanceClusterLayout());
        dPattern.setVisibleElements(this.visibility);
        dPattern.build();
        AWTCanvas realAwtCanvas = new AWTCanvas(new Canvas(primitiveFactory, dPattern));
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        Rectangle componentBounds = this.awtCanvas.getBounds(null);
        graphics.translate(-componentBounds.x, -componentBounds.y);
        realAwtCanvas.paint(graphics);
        return 0;
    }

    public void scaleToFit(boolean useSymmetricScaling) {
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.awtCanvas.getBounds(null);
        int scaleX = (int)format.getImageableWidth() / componentBounds.width;
        int scaleY = (int)format.getImageableHeight() / componentBounds.height;
        if (scaleX < 1 || scaleY < 1) {
            if (useSymmetricScaling) {
                if (scaleX < scaleY) {
                    scaleY = scaleX;
                } else {
                    scaleX = scaleY;
                }
            }
            this.setSize(componentBounds.width * scaleX, componentBounds.height * scaleY);
            this.setScale(scaleX, scaleY);
        }
    }

    public void scaleToFitX() {
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.awtCanvas.getBounds(null);
        int scaleX = (int)format.getImageableWidth() / componentBounds.width;
        int scaleY = this.scaleX;
        if (scaleX < 1) {
            this.setSize((float)format.getImageableWidth(), componentBounds.height * scaleY);
            this.setScale(scaleX, scaleY);
        }
    }

    public void scaleToFitY() {
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.awtCanvas.getBounds(null);
        int scaleY = (int)format.getImageableHeight() / componentBounds.height;
        int scaleX = this.scaleY;
        if (scaleY < 1) {
            this.setSize(componentBounds.width * scaleX, (float)format.getImageableHeight());
            this.setScale(scaleX, scaleY);
        }
    }

    protected void setCanvas(AWTCanvas awtCanvas) {
        this.awtCanvas = awtCanvas;
    }

    protected void setScale(int scaleX, int scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }
}

