/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import util.PropertyManager;

public class NamedInputStream {
    private final String fileName;
    private byte[] bytes;

    public NamedInputStream(String aFileName, InputStream aStream) {
        this.fileName = aFileName.replace('\\', PropertyManager.getSeparatorChar());
        try {
            this.bytes = new byte[aStream.available()];
            int b = 0;
            int i = 0;
            while ((b = aStream.read()) != -1) {
                this.bytes[i++] = (byte)b;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getName() {
        return this.fileName;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public String toString() {
        return this.getName();
    }
}

