/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import util.io.AutoFlushPrintWriter;

public class OutputManager {
    private static OutputManager UNIQUE_INSTANCE;
    private PrintWriter debugOutput = new AutoFlushPrintWriter(new OutputStreamWriter(System.err));
    private PrintWriter errorOutput = new AutoFlushPrintWriter(new OutputStreamWriter(System.err));
    private PrintWriter normalOutput = new AutoFlushPrintWriter(new OutputStreamWriter(System.out));

    public static OutputManager getCurrentOutputManager() {
        if (UNIQUE_INSTANCE == null) {
            UNIQUE_INSTANCE = new OutputManager();
        }
        return UNIQUE_INSTANCE;
    }

    private OutputManager() {
    }

    public PrintWriter getDebugOutput() {
        return this.debugOutput;
    }

    public PrintWriter getErrorOutput() {
        return this.errorOutput;
    }

    public PrintWriter getNormalOutput() {
        return this.normalOutput;
    }

    public void setDebugOutput(PrintWriter messageWriter) {
        this.debugOutput = messageWriter;
    }

    public void setErrorOutput(PrintWriter messageWriter) {
        this.errorOutput = messageWriter;
    }

    public void setNormalOutput(PrintWriter messageWriter) {
        this.normalOutput = messageWriter;
    }
}

