/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class OutputMonitor
extends Thread {
    private final String header;
    private final InputStream inputStream;
    private final PrintStream printStream;
    private boolean isVerbose;

    public OutputMonitor(String threadName, String header, InputStream inputStream, PrintStream printStream) {
        this.setName(threadName);
        this.setPriority(10);
        this.header = header;
        this.inputStream = inputStream;
        this.printStream = printStream;
        this.isVerbose = true;
    }

    public void run() {
        try {
            int value = 0;
            while ((value = this.inputStream.read()) > 0) {
                PrintStream printStream = System.err;
                synchronized (printStream) {
                    PrintStream printStream2 = System.out;
                    synchronized (printStream2) {
                        if (value != 13 && value != 10) {
                            char lastWrittenChar = (char)value;
                            if (this.isVerbose) {
                                this.printStream.print(this.header);
                                this.printStream.print(' ');
                                this.printStream.print(lastWrittenChar);
                                while (value > 0) {
                                    int available = this.inputStream.available();
                                    byte[] bytes = new byte[available];
                                    value = this.inputStream.read(bytes, 0, available);
                                    int i = 0;
                                    while (i < value) {
                                        lastWrittenChar = (char)bytes[i];
                                        this.printStream.print(lastWrittenChar);
                                        ++i;
                                    }
                                }
                                this.printStream.flush();
                            }
                        } else {
                            this.printStream.println();
                            this.printStream.flush();
                            this.inputStream.read();
                        }
                    }
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }
}

