/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import com.ibm.toad.cfparse.ClassFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import util.PropertyManager;
import util.io.ExtensionBasedFilenameFilter;
import util.io.NamedInputStream;
import util.io.OutputManager;

public final class SubtypeLoader {
    public static ClassFile[] loadRecursivelySubtypesFromDir(String supertypeName, String directory, String extension) {
        File currentDirectory = new File(directory);
        String[] currentList = currentDirectory.list();
        if (currentList == null || currentList.length == 0) {
            OutputManager.getCurrentOutputManager().getErrorOutput().println("Loader: No files found into " + directory);
            return new ClassFile[0];
        }
        ArrayList<ClassFile> currentListOfClasses = new ArrayList<ClassFile>(currentList.length);
        int x = 0;
        while (x < currentList.length) {
            String itemName = String.valueOf(directory) + currentList[x];
            if (new File(itemName).isFile()) {
                currentListOfClasses.addAll(Arrays.asList(SubtypeLoader.loadSubtypeFromFile(supertypeName, itemName, extension)));
            } else if (new File(itemName).isDirectory()) {
                currentListOfClasses.addAll(Arrays.asList(SubtypeLoader.loadRecursivelySubtypesFromDir(supertypeName, String.valueOf(itemName) + File.separatorChar, extension)));
            }
            ++x;
        }
        if (currentListOfClasses.size() == 0) {
            OutputManager.getCurrentOutputManager().getErrorOutput().println("Loader: No files found into " + directory);
            return new ClassFile[0];
        }
        ClassFile[] results = new ClassFile[currentListOfClasses.size()];
        currentListOfClasses.toArray(results);
        Arrays.sort(results, new ClassNameAlphabeticalComparator());
        return results;
    }

    public static ClassFile[] loadSubtypeFromFile(String supertypeName, String file, String extension) {
        ArrayList currentListOfClasses = new ArrayList(1);
        if (file.endsWith(extension)) {
            OutputManager.getCurrentOutputManager().getNormalOutput().print("Loading from: ");
            OutputManager.getCurrentOutputManager().getNormalOutput().println(file);
            try {
                FileInputStream inputStream = new FileInputStream(file);
                SubtypeLoader.loadSubtypeFromStream(supertypeName, currentListOfClasses, inputStream);
                ((InputStream)inputStream).close();
            }
            catch (FileNotFoundException inputStream) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ClassFile[] results = new ClassFile[currentListOfClasses.size()];
        currentListOfClasses.toArray(results);
        return results;
    }

    private static void loadSubtypeFromStream(String supertypeName, List currentListOfClasses, InputStream inputStream) {
        try {
            ClassFile currentClass = new ClassFile(inputStream);
            if (supertypeName == null || currentClass.getSuperName().equals(supertypeName)) {
                currentListOfClasses.add(currentClass);
            } else {
                boolean isSuperInterfaceFound = false;
                int i = 0;
                while (i < currentClass.getInterfaces().length() && !isSuperInterfaceFound) {
                    if (currentClass.getInterfaces().get(i).equals(supertypeName)) {
                        currentListOfClasses.add(currentClass);
                        isSuperInterfaceFound = true;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ClassFile[] loadSubtypesFromDir(String supertypeName, String directory, String extension) {
        File currentDirectory = new File(directory);
        String[] currentList = currentDirectory.list(new ExtensionBasedFilenameFilter(extension));
        if (currentList == null || currentList.length == 0) {
            OutputManager.getCurrentOutputManager().getErrorOutput().println("Loader: No files found into " + directory);
            return new ClassFile[0];
        }
        ArrayList<ClassFile> currentListOfClasses = new ArrayList<ClassFile>(currentList.length);
        int x = 0;
        while (x < currentList.length) {
            currentListOfClasses.addAll(Arrays.asList(SubtypeLoader.loadSubtypeFromFile(supertypeName, String.valueOf(directory) + currentList[x], extension)));
            ++x;
        }
        ClassFile[] results = new ClassFile[currentListOfClasses.size()];
        currentListOfClasses.toArray(results);
        Arrays.sort(results, new ClassNameAlphabeticalComparator());
        return results;
    }

    public static ClassFile[] loadSubtypesFromJar(ClassFile supertype, String jarFileName, String extension) {
        try {
            JarFile currentJarFile = new JarFile(jarFileName);
            if (currentJarFile.size() == 0) {
                OutputManager.getCurrentOutputManager().getErrorOutput().println("Loader: No files found into " + jarFileName);
                return new ClassFile[0];
            }
            ArrayList<ClassFile> currentListOfClasses = new ArrayList<ClassFile>();
            Enumeration<JarEntry> classList = currentJarFile.entries();
            while (classList.hasMoreElements()) {
                try {
                    JarEntry jarEntry = classList.nextElement();
                    if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(extension)) continue;
                    InputStream inputStream = currentJarFile.getInputStream(jarEntry);
                    ClassFile currentClass = new ClassFile(inputStream);
                    if (supertype == null || currentClass.getSuperName() != null && currentClass.getSuperName().equals(supertype.getName())) {
                        currentListOfClasses.add(currentClass);
                        continue;
                    }
                    boolean isSuperInterfaceFound = false;
                    int i = 0;
                    while (i < currentClass.getInterfaces().length() && !isSuperInterfaceFound) {
                        if (currentClass.getInterfaces().get(i).equals(supertype.getName())) {
                            currentListOfClasses.add(currentClass);
                            isSuperInterfaceFound = true;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ClassFile[] results = new ClassFile[currentListOfClasses.size()];
            currentListOfClasses.toArray(results);
            Arrays.sort(results, new ClassNameAlphabeticalComparator());
            return results;
        }
        catch (IOException ioe) {
            OutputManager.getCurrentOutputManager().getErrorOutput().println("Loader: Error while reading file " + jarFileName);
            return new ClassFile[0];
        }
    }

    public static ClassFile[] loadSubtypesFromStream(String supertypeName, NamedInputStream[] files, String packageName, String extension) {
        String directory = String.valueOf(packageName.replace('.', PropertyManager.getSeparatorChar())) + PropertyManager.getSeparatorChar();
        ArrayList currentListOfClasses = new ArrayList();
        int i = 0;
        while (i < files.length) {
            int index;
            if (files[i].getName().endsWith(extension) && (index = files[i].getName().indexOf(directory)) > -1 && files[i].getName().indexOf(File.separatorChar, index + directory.length() + 1) == -1) {
                OutputManager.getCurrentOutputManager().getNormalOutput().print("Loading from: ");
                OutputManager.getCurrentOutputManager().getNormalOutput().println(files[i].getName());
                SubtypeLoader.loadSubtypeFromStream(supertypeName, currentListOfClasses, files[i].getStream());
            }
            ++i;
        }
        ClassFile[] results = new ClassFile[currentListOfClasses.size()];
        currentListOfClasses.toArray(results);
        Arrays.sort(results, new ClassNameAlphabeticalComparator());
        return results;
    }

    private SubtypeLoader() {
    }

    private static class ClassNameAlphabeticalComparator
    implements Comparator {
        ClassNameAlphabeticalComparator() {
        }

        public int compare(Class c1, Class c2) {
            return c1.getName().compareTo(c2.getName());
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Class && o2 instanceof Class) {
                return this.compare((Class)o1, (Class)o2);
            }
            return 0;
        }
    }
}

