/*
 * Decompiled with CFR 0.152.
 */
package util.lang;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;

public class ClassLoader
extends java.lang.ClassLoader {
    private final String directory;

    private ClassLoader() {
        this.directory = null;
    }

    public ClassLoader(java.lang.ClassLoader parent, String directory) {
        super(parent);
        this.directory = directory;
    }

    protected Class defineClasses(String name, InputStream inputStream) {
        try {
            int b;
            int length = 0;
            byte[] bytes = new byte[4];
            while ((b = inputStream.read()) != -1) {
                if (length == bytes.length) {
                    byte[] temp = new byte[length + 4];
                    System.arraycopy(bytes, 0, temp, 0, length);
                    bytes = temp;
                }
                bytes[length] = (byte)b;
                ++length;
            }
            System.out.println(name);
            Class<?> newClass = this.defineClass(name, bytes, 0, length);
            return newClass;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            ncdfe.printStackTrace();
            return null;
        }
    }

    public Class findClass(String name) {
        Class newClass = null;
        try {
            newClass = super.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            String osName = String.valueOf(this.directory) + name.replace('.', '/') + ".class";
            try {
                FileInputStream fis = new FileInputStream(osName);
                newClass = this.defineClasses(name, fis);
            }
            catch (ClassFormatError cfe) {
                System.err.print("The file ");
                System.err.print(osName);
                System.err.println(" produces an error.");
                cfe.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return newClass;
    }

    protected URL findResource(String name) {
        URL url = super.findResource(name);
        if (url == null) {
            try {
                url = new URL("file", "", "/" + this.directory);
            }
            catch (MalformedURLException mfue) {
                mfue.printStackTrace();
            }
        }
        return url;
    }

    public Class loadClass(String name, JarFile jarFile) {
        Class newClass = null;
        try {
            newClass = super.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            String osName = String.valueOf(name.replace('.', '/')) + ".class";
            try {
                newClass = this.defineClasses(name, jarFile.getInputStream(jarFile.getJarEntry(osName)));
            }
            catch (ClassFormatError cfe) {
                System.err.print("The file ");
                System.err.print(osName);
                System.err.println(" produces an error.");
                cfe.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return newClass;
    }
}

